/*
 * Decompiled with CFR 0.152.
 */
package com.jansensystems.pdfspicer;

import com.jansensystems.pdfspicer.ProgressListener;
import com.lowagie.text.Document;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGState;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class Watermarker {
    private File outFile = null;
    private String watermarkText = "";
    private String titleText = "";
    private PdfStamper stamp = null;
    private PdfReader reader = null;
    public int status = 0;
    public String error = "";
    private int maxTitleFontSize = 12;
    private int topSpacing = 20;
    private int splitPages = 0;
    private int splitPagesPerPart = 0;
    private ProgressListener progressListener = null;

    public void setTopSpacing(int i) {
        this.topSpacing = i;
    }

    public void setMaxTitleFontSize(int i) {
        this.maxTitleFontSize = i;
    }

    public void setWatermarkText(String s) {
        this.watermarkText = s;
    }

    public void setTitleText(String s) {
        this.titleText = s;
    }

    public Watermarker(File in, File out) throws Exception {
        this.outFile = out;
        this.reader = new PdfReader(new FileInputStream(in));
    }

    private int[] getParts(int n, int pages, int pagesperpart) {
        int[] ret;
        if (pages == 0 && pagesperpart == 0) {
            ret = new int[]{n};
        } else if (pagesperpart > 0) {
            int max;
            if (pagesperpart > n) {
                pagesperpart = n;
            }
            if ((max = n / pagesperpart) * pagesperpart < n) {
                ++max;
            }
            ret = new int[max + 1];
            for (int i = 0; i < max - 1; ++i) {
                ret[i] = (i + 1) * pagesperpart;
            }
            ret[max - 1] = n;
            ret[max] = 0;
        } else {
            if (pages > n) {
                pages = n;
            }
            ret = new int[pages + 1];
            int part = n / pages;
            if (n % pages > 0) {
                // empty if block
            }
            ret[0] = ++part;
            for (int i = 1; i < pages - 1; ++i) {
                ret[i] = part + ret[i - 1];
            }
            ret[pages - 1] = n;
            ret[pages] = 0;
        }
        return ret;
    }

    private void splitPages(File tempOut) throws Exception {
        int counter = 0;
        Document d = null;
        PdfWriter wr = null;
        PdfReader r = new PdfReader(new FileInputStream(tempOut));
        int n = r.getNumberOfPages();
        int currentpage = 0;
        int[] parts = this.getParts(n, this.splitPages, this.splitPagesPerPart);
        String filename = this.outFile.getPath();
        if (parts.length > 1) {
            filename = filename.replaceAll("\\.pdf", "_%03d.pdf");
        }
        File f = new File(String.format(filename, counter + 1));
        d = new Document(r.getPageSizeWithRotation(1));
        wr = PdfWriter.getInstance(d, new FileOutputStream(f));
        d.open();
        PdfContentByte cb1 = wr.getDirectContent();
        while (parts[counter] > 0) {
            if (++currentpage > parts[counter]) {
                d.close();
                if (parts[++counter] == 0) break;
                f = new File(String.format(filename, counter + 1));
                d = new Document(r.getPageSizeWithRotation(1));
                wr = PdfWriter.getInstance(d, new FileOutputStream(f));
                d.open();
                cb1 = wr.getDirectContent();
            }
            if (currentpage > n) break;
            d.setPageSize(r.getPageSizeWithRotation(currentpage));
            d.newPage();
            PdfImportedPage page = wr.getImportedPage(r, currentpage);
            int rotation = r.getPageRotation(currentpage);
            if (rotation == 90 || rotation == 270) {
                cb1.addTemplate(page, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, r.getPageSizeWithRotation(currentpage).height());
                continue;
            }
            cb1.addTemplate(page, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }
        d.close();
        r.close();
        tempOut.delete();
        this.outFile.delete();
    }

    public boolean watermark() throws Exception {
        PdfGState gstate = new PdfGState();
        gstate.setFillOpacity(0.2f);
        gstate.setStrokeOpacity(0.2f);
        PdfGState gstate_full = new PdfGState();
        gstate_full.setFillOpacity(1.0f);
        gstate_full.setStrokeOpacity(1.0f);
        int n = this.reader.getNumberOfPages();
        BaseFont bf = BaseFont.createFont("Helvetica", "Cp1252", true);
        File loutFile = this.outFile;
        if (this.splitPages > 1 || this.splitPagesPerPart > 0) {
            loutFile = File.createTempFile(loutFile.getName(), ".pdf", loutFile.getParentFile());
            loutFile.deleteOnExit();
        }
        this.stamp = new PdfStamper(this.reader, new FileOutputStream(loutFile));
        for (int i = 1; i <= n; ++i) {
            float new_height;
            int text_height;
            int font_size;
            float max_width;
            float width;
            float height;
            if (this.progressListener != null) {
                int progress = (int)((float)i / (float)n * 100.0f);
                this.progressListener.setProgress(progress);
            }
            PdfContentByte cb = this.stamp.getOverContent(i);
            if (this.reader.getPageRotation(i) == 90 || this.reader.getPageRotation(i) == 270) {
                height = this.reader.getPageSize(i).width();
                width = this.reader.getPageSize(i).height();
            } else {
                width = this.reader.getPageSize(i).width();
                height = this.reader.getPageSize(i).height();
            }
            if (this.watermarkText.length() > 0) {
                cb.saveState();
                cb.setGState(gstate);
                cb.setColorFill(Color.black);
                cb.beginText();
                max_width = (float)this.getDiagonalWidth(width, height);
                int alpha = this.getAngle(height, max_width);
                font_size = this.setMaxFontSize(cb, this.watermarkText, max_width * 0.7f, bf);
                text_height = this.getTextHeight(font_size);
                new_height = height - (float)(text_height / 2);
                cb.showTextAligned(1, this.watermarkText, width / 2.0f, new_height / 2.0f, alpha);
                cb.endText();
            }
            if (this.titleText.length() <= 0) continue;
            cb.saveState();
            cb.setGState(gstate_full);
            cb.setColorFill(Color.black);
            cb.beginText();
            max_width = width;
            font_size = this.setMaxFontSize(cb, this.titleText, max_width * 0.7f, bf);
            if (font_size > this.maxTitleFontSize) {
                font_size = this.maxTitleFontSize;
                cb.setFontAndSize(bf, font_size);
            }
            text_height = this.getTextHeight(font_size);
            new_height = height - (float)text_height - (float)this.topSpacing;
            cb.showTextAligned(1, this.titleText, width / 2.0f, new_height, 0.0f);
            cb.endText();
        }
        this.stamp.close();
        this.reader.close();
        if (this.splitPages > 0 || this.splitPagesPerPart > 0) {
            this.splitPages(loutFile);
        }
        return true;
    }

    private int getAngle(float x, float y) {
        return (int)Math.round(Math.toDegrees(Math.asin(x / y)));
    }

    private int setMaxFontSize(PdfContentByte cb, String text, float max_width, BaseFont bf) {
        int i = 1;
        cb.setFontAndSize(bf, i);
        while (cb.getEffectiveStringWidth(text, false) < max_width) {
            cb.setFontAndSize(bf, ++i);
        }
        cb.setFontAndSize(bf, i - 1);
        return i - 1;
    }

    private int getTextHeight(int points) {
        return Math.round((float)points * 1.333f);
    }

    private double getDiagonalWidth(double x, double y) {
        return Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0));
    }

    public int getSplitPages() {
        return this.splitPages;
    }

    public void setSplitPages(int splitPages) {
        this.splitPages = splitPages;
    }

    public ProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public int getSplitPagesPerPart() {
        return this.splitPagesPerPart;
    }

    public void setSplitPagesPerPart(int splitPagesPerPart) {
        this.splitPagesPerPart = splitPagesPerPart;
    }
}

