/*
 * Decompiled with CFR 0.152.
 */
package com.jansensystems.pdfspicer;

import com.jansensystems.pdfspicer.PDFFile;
import java.io.File;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFFileModel
extends AbstractTableModel {
    private ArrayList<PDFFile> pdffiles = new ArrayList();

    public void addPDF(File f) throws Exception {
        PDFFile file = new PDFFile(f);
        if (!this.pdffiles.contains(file)) {
            this.pdffiles.add(file);
            int row = this.pdffiles.indexOf(file);
            this.fireTableRowsInserted(row, row);
        }
    }

    public void addPDF(PDFFile f) {
        if (!this.pdffiles.contains(f)) {
            this.pdffiles.add(f);
            int row = this.pdffiles.indexOf(f);
            this.fireTableRowsInserted(row, row);
        }
    }

    public void addPDFs(PDFFile[] ff) {
        for (PDFFile f : ff) {
            if (this.pdffiles.contains(f)) continue;
            this.pdffiles.add(f);
        }
        this.fireTableDataChanged();
    }

    public void removePDFs(PDFFile[] ff) {
        for (PDFFile f : ff) {
            this.pdffiles.remove(f);
        }
        this.fireTableDataChanged();
    }

    public void removePDF(PDFFile f) {
        int row = this.pdffiles.indexOf(f);
        this.pdffiles.remove(f);
        this.fireTableRowsDeleted(row, row);
    }

    public PDFFile getPDF(int row) {
        return this.pdffiles.get(row);
    }

    public ArrayList<PDFFile> getPDFFiles() {
        return this.pdffiles;
    }

    @Override
    public int getRowCount() {
        return this.pdffiles.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.pdffiles.get(rowIndex).getFile();
            }
            case 1: {
                return this.pdffiles.get(rowIndex).getFile();
            }
            case 2: {
                return this.pdffiles.get(rowIndex).getPages();
            }
        }
        return "";
    }

    @Override
    public String getColumnName(int col) {
        String ret = "";
        switch (col) {
            case 0: {
                ret = "Filename";
                break;
            }
            case 1: {
                ret = "Filesize";
                break;
            }
            case 2: {
                ret = "Pages";
            }
        }
        return ret;
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: {
                return File.class;
            }
            case 1: {
                return File.class;
            }
            case 2: {
                return Integer.class;
            }
        }
        return String.class;
    }
}

