/*
 * Decompiled with CFR 0.152.
 */
package com.jansensystems.pdfspicer;

import com.jansensystems.jswidgets.FileDropTableListener;
import com.jansensystems.jswidgets.JCenterFrame;
import com.jansensystems.jswidgets.JFileDropTable;
import com.jansensystems.jswidgets.ProgressGlassPane;
import com.jansensystems.jswidgets.border.ComponentTitledBorder;
import com.jansensystems.jswidgets.filefilters.PDFFilter;
import com.jansensystems.jswidgets.renderer.TableFileRenderer;
import com.jansensystems.pdfspicer.PDFFile;
import com.jansensystems.pdfspicer.PDFFileModel;
import com.jansensystems.pdfspicer.ProgressListener;
import com.jansensystems.pdfspicer.Watermarker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.DefaultTableModel;

public class MainWindow
extends JCenterFrame {
    private JCheckBox ckWatermark = new JCheckBox(ResourceBundle.getBundle("com/jansensystems/pdfspicer/Bundle").getString("Add_watermark"));
    private JCheckBox ckTitle = new JCheckBox(ResourceBundle.getBundle("com/jansensystems/pdfspicer/Bundle").getString("Add_headline"));
    private JCheckBox ckSplit = new JCheckBox(ResourceBundle.getBundle("com/jansensystems/pdfspicer/Bundle").getString("Split_files"));
    private File outDir = null;
    private ProgressGlassPane glassPane = new ProgressGlassPane(ResourceBundle.getBundle("com/jansensystems/pdfspicer/Bundle").getString("MainWindow.glassPane.title.Processing_file"));
    private File lastDir = null;
    private ProgressListener progressListener = new ProgressListener(){

        public void setProgress(int progress) {
            MainWindow.this.glassPane.setProgress(progress);
        }

        public void setProgressText(String text) {
            MainWindow.this.glassPane.setTitle(text);
        }
    };
    private JButton btnAddFiles;
    private JButton btnBrowseOutputDir;
    private JButton btnClose;
    private ButtonGroup btnGroupParts;
    private JButton btnRemoveFiles;
    private JButton btnRun;
    private JCheckBox ckFileNameAsText;
    private JFileChooser fileChooser;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JScrollPane jScrollPane1;
    private JPanel panelHeadline;
    private JPanel panelSplit;
    private JPanel panelWatermark;
    private JRadioButton radioNumberOfParts;
    private JRadioButton radioPagesPerPart;
    private JSpinner spMaxFontSize;
    private JSpinner spPagesPerPage;
    private JSpinner spSplitParts;
    private JSpinner spTopSpacing;
    private JTable tblInputFiles;
    private JTextField txtHeadlineText;
    private JTextField txtOutputDirectory;
    private JTextField txtWatermark;

    public MainWindow() {
        this.initComponents();
        PDFFileModel pfm = new PDFFileModel();
        this.tblInputFiles.setDefaultRenderer(File.class, new TableFileRenderer(0, 1));
        this.tblInputFiles.setModel(pfm);
        ((JFileDropTable)this.tblInputFiles).setFileDropListener(new FileDropTableListener(){

            public boolean acceptFile(File f) {
                return f.exists() && !f.isDirectory() && f.canRead() && this.getExtension(f) != null && this.getExtension(f).equals("pdf");
            }

            private String getExtension(File f) {
                String ext = null;
                String s = f.getName();
                int i = s.lastIndexOf(46);
                if (i > 0 && i < s.length() - 1) {
                    ext = s.substring(i + 1).toLowerCase();
                }
                return ext;
            }

            public void done() {
                MainWindow.this.checkIfRunnable();
            }

            public void fileDropped(File f, int tableRow) {
                try {
                    ((PDFFileModel)MainWindow.this.tblInputFiles.getModel()).addPDF(f);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(MainWindow.this, e.getLocalizedMessage(), ResourceBundle.getBundle("com/jansensystems/pdfspicer/Bundle").getString("ERROR"), 0);
                }
            }
        });
        ComponentTitledBorder border = new ComponentTitledBorder(this.ckWatermark, this.panelWatermark, BorderFactory.createEtchedBorder());
        this.panelWatermark.setBorder(border);
        this.ckWatermark.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.txtWatermark.setEnabled(MainWindow.this.ckWatermark.isSelected());
            }
        });
        border = new ComponentTitledBorder(this.ckTitle, this.panelHeadline, BorderFactory.createEtchedBorder());
        this.panelHeadline.setBorder(border);
        this.ckTitle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.ckFileNameAsText.setEnabled(MainWindow.this.ckTitle.isSelected());
                MainWindow.this.txtHeadlineText.setEnabled(MainWindow.this.ckTitle.isSelected() && !MainWindow.this.ckFileNameAsText.isSelected());
                MainWindow.this.spMaxFontSize.setEnabled(MainWindow.this.ckTitle.isSelected());
                MainWindow.this.spTopSpacing.setEnabled(MainWindow.this.ckTitle.isSelected());
            }
        });
        border = new ComponentTitledBorder(this.ckSplit, this.panelSplit, BorderFactory.createEtchedBorder());
        this.panelSplit.setBorder(border);
        this.ckSplit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.radioNumberOfParts.setEnabled(MainWindow.this.ckSplit.isSelected());
                MainWindow.this.radioPagesPerPart.setEnabled(MainWindow.this.ckSplit.isSelected());
                MainWindow.this.spSplitParts.setEnabled(MainWindow.this.ckSplit.isSelected() && MainWindow.this.radioNumberOfParts.isSelected());
                MainWindow.this.spPagesPerPage.setEnabled(MainWindow.this.ckSplit.isSelected() && MainWindow.this.radioPagesPerPart.isSelected());
            }
        });
        this.setGlassPane(this.glassPane);
        this.glassPane.setBarWidth(350);
        this.pack();
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.pack();
        }
    }

    private void checkIfRunnable() {
        this.btnRun.setEnabled(this.outDir != null && this.tblInputFiles.getRowCount() > 0);
    }

    private void initComponents() {
        this.fileChooser = new JFileChooser();
        this.btnGroupParts = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tblInputFiles = new JFileDropTable();
        this.jLabel2 = new JLabel();
        this.txtOutputDirectory = new JTextField();
        this.btnBrowseOutputDir = new JButton();
        this.btnRemoveFiles = new JButton();
        this.btnAddFiles = new JButton();
        this.panelWatermark = new JPanel();
        this.jLabel3 = new JLabel();
        this.txtWatermark = new JTextField();
        this.panelHeadline = new JPanel();
        this.ckFileNameAsText = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.spMaxFontSize = new JSpinner();
        this.jLabel5 = new JLabel();
        this.spTopSpacing = new JSpinner();
        this.jLabel6 = new JLabel();
        this.txtHeadlineText = new JTextField();
        this.panelSplit = new JPanel();
        this.spSplitParts = new JSpinner();
        this.radioNumberOfParts = new JRadioButton();
        this.spPagesPerPage = new JSpinner();
        this.radioPagesPerPart = new JRadioButton();
        this.btnClose = new JButton();
        this.btnRun = new JButton();
        this.fileChooser.setCurrentDirectory(null);
        this.setDefaultCloseOperation(3);
        ResourceBundle bundle = ResourceBundle.getBundle("com/jansensystems/pdfspicer/Bundle");
        this.setTitle(bundle.getString("MainWindow.title"));
        this.jLabel1.setText(bundle.getString("MainWindow.jLabel1.text"));
        this.tblInputFiles.setAutoCreateRowSorter(true);
        this.tblInputFiles.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.tblInputFiles);
        this.jLabel2.setText(bundle.getString("MainWindow.jLabel2.text"));
        this.txtOutputDirectory.setEditable(false);
        this.txtOutputDirectory.setText(bundle.getString("MainWindow.txtOutputDirectory.text"));
        this.btnBrowseOutputDir.setText(bundle.getString("MainWindow.btnBrowseOutputDir.text"));
        this.btnBrowseOutputDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.btnBrowseOutputDirActionPerformed(evt);
            }
        });
        this.btnRemoveFiles.setText(bundle.getString("MainWindow.btnRemoveFiles.text"));
        this.btnRemoveFiles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.btnRemoveFilesActionPerformed(evt);
            }
        });
        this.btnAddFiles.setText(bundle.getString("MainWindow.btnAddFiles.text"));
        this.btnAddFiles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.btnAddFilesActionPerformed(evt);
            }
        });
        this.jLabel3.setText(bundle.getString("MainWindow.jLabel3.text"));
        this.txtWatermark.setText(bundle.getString("MainWindow.txtWatermark.text"));
        this.txtWatermark.setEnabled(false);
        GroupLayout panelWatermarkLayout = new GroupLayout(this.panelWatermark);
        this.panelWatermark.setLayout(panelWatermarkLayout);
        panelWatermarkLayout.setHorizontalGroup(panelWatermarkLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelWatermarkLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtWatermark, -1, 816, Short.MAX_VALUE).addContainerGap()));
        panelWatermarkLayout.setVerticalGroup(panelWatermarkLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelWatermarkLayout.createSequentialGroup().addContainerGap().addGroup(panelWatermarkLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.txtWatermark, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.ckFileNameAsText.setText(bundle.getString("MainWindow.ckFileNameAsText.text"));
        this.ckFileNameAsText.setEnabled(false);
        this.ckFileNameAsText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.ckFileNameAsTextActionPerformed(evt);
            }
        });
        this.jLabel4.setText(bundle.getString("MainWindow.jLabel4.text"));
        this.spMaxFontSize.setModel(new SpinnerNumberModel((Number)12, Integer.valueOf(6), null, (Number)1));
        this.spMaxFontSize.setEnabled(false);
        this.jLabel5.setText(bundle.getString("MainWindow.jLabel5.text"));
        this.spTopSpacing.setModel(new SpinnerNumberModel((Number)20, Integer.valueOf(0), null, (Number)1));
        this.spTopSpacing.setEnabled(false);
        this.jLabel6.setText(bundle.getString("MainWindow.jLabel6.text"));
        this.txtHeadlineText.setText(bundle.getString("MainWindow.txtHeadlineText.text"));
        this.txtHeadlineText.setEnabled(false);
        GroupLayout panelHeadlineLayout = new GroupLayout(this.panelHeadline);
        this.panelHeadline.setLayout(panelHeadlineLayout);
        panelHeadlineLayout.setHorizontalGroup(panelHeadlineLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelHeadlineLayout.createSequentialGroup().addContainerGap().addGroup(panelHeadlineLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelHeadlineLayout.createSequentialGroup().addComponent(this.ckFileNameAsText).addGap(50, 50, 50).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spMaxFontSize, -2, 88, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 392, Short.MAX_VALUE).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spTopSpacing, -2, 73, -2)).addGroup(panelHeadlineLayout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtHeadlineText, -1, 888, Short.MAX_VALUE))).addContainerGap()));
        panelHeadlineLayout.setVerticalGroup(panelHeadlineLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelHeadlineLayout.createSequentialGroup().addContainerGap().addGroup(panelHeadlineLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ckFileNameAsText).addComponent(this.jLabel5).addComponent(this.spTopSpacing, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.spMaxFontSize, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelHeadlineLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.txtHeadlineText, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.spSplitParts.setModel(new SpinnerNumberModel((Number)4, Integer.valueOf(2), null, (Number)1));
        this.spSplitParts.setEnabled(false);
        this.btnGroupParts.add(this.radioNumberOfParts);
        this.radioNumberOfParts.setSelected(true);
        this.radioNumberOfParts.setText(bundle.getString("MainWindow.radioNumberOfParts.text"));
        this.radioNumberOfParts.setEnabled(false);
        this.radioNumberOfParts.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.radioNumberOfPartsActionPerformed(evt);
            }
        });
        this.spPagesPerPage.setModel(new SpinnerNumberModel(10, 1, 1000, 1));
        this.spPagesPerPage.setEnabled(false);
        this.btnGroupParts.add(this.radioPagesPerPart);
        this.radioPagesPerPart.setText(bundle.getString("MainWindow.radioPagesPerPart.text"));
        this.radioPagesPerPart.setEnabled(false);
        this.radioPagesPerPart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.radioPagesPerPartActionPerformed(evt);
            }
        });
        GroupLayout panelSplitLayout = new GroupLayout(this.panelSplit);
        this.panelSplit.setLayout(panelSplitLayout);
        panelSplitLayout.setHorizontalGroup(panelSplitLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelSplitLayout.createSequentialGroup().addContainerGap().addComponent(this.radioNumberOfParts).addGap(18, 18, 18).addComponent(this.spSplitParts, -2, 81, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 475, Short.MAX_VALUE).addComponent(this.radioPagesPerPart).addGap(18, 18, 18).addComponent(this.spPagesPerPage, -2, 84, -2).addContainerGap()));
        panelSplitLayout.setVerticalGroup(panelSplitLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelSplitLayout.createSequentialGroup().addContainerGap().addGroup(panelSplitLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioNumberOfParts).addComponent(this.spSplitParts, -2, -1, -2).addComponent(this.spPagesPerPage, -2, -1, -2).addComponent(this.radioPagesPerPart)).addContainerGap(-1, Short.MAX_VALUE)));
        this.btnClose.setText(bundle.getString("MainWindow.btnClose.text"));
        this.btnClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.btnCloseActionPerformed(evt);
            }
        });
        this.btnRun.setText(bundle.getString("MainWindow.btnRun.text"));
        this.btnRun.setEnabled(false);
        this.btnRun.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.btnRunActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelSplit, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.panelHeadline, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.panelWatermark, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 955, Short.MAX_VALUE).addComponent(this.jLabel1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtOutputDirectory, -1, 736, Short.MAX_VALUE)).addComponent(this.btnAddFiles, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnBrowseOutputDir, -1, -1, Short.MAX_VALUE).addComponent(this.btnRemoveFiles, -1, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.btnRun).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClose))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 150, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnRemoveFiles).addComponent(this.btnAddFiles)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.btnBrowseOutputDir).addComponent(this.txtOutputDirectory, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelWatermark, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelHeadline, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelSplit, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnClose).addComponent(this.btnRun)).addContainerGap()));
        this.pack();
    }

    private void ckFileNameAsTextActionPerformed(ActionEvent evt) {
        this.txtHeadlineText.setEnabled(!this.ckFileNameAsText.isSelected());
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void btnRemoveFilesActionPerformed(ActionEvent evt) {
        PDFFile[] files = new PDFFile[this.tblInputFiles.getSelectedRowCount()];
        int count = 0;
        for (int i : this.tblInputFiles.getSelectedRows()) {
            int row = this.tblInputFiles.convertRowIndexToModel(i);
            files[count] = ((PDFFileModel)this.tblInputFiles.getModel()).getPDF(row);
            ++count;
        }
        ((PDFFileModel)this.tblInputFiles.getModel()).removePDFs(files);
        this.checkIfRunnable();
    }

    private void btnBrowseOutputDirActionPerformed(ActionEvent evt) {
        this.fileChooser = this.lastDir == null ? new JFileChooser() : new JFileChooser(this.lastDir);
        this.fileChooser.setDialogTitle(ResourceBundle.getBundle("com/jansensystems/pdfspicer/Bundle").getString("dialog_title_select_target_dir"));
        this.fileChooser.setApproveButtonText(ResourceBundle.getBundle("com/jansensystems/pdfspicer/Bundle").getString("MainWindow.filechooser.button.opendir.text"));
        this.fileChooser.setFileSelectionMode(1);
        this.fileChooser.setMultiSelectionEnabled(false);
        if (this.fileChooser.showOpenDialog(this) == 0) {
            this.lastDir = this.fileChooser.getCurrentDirectory();
            File f = this.fileChooser.getSelectedFile();
            if (f.exists() && f.isDirectory() && f.canWrite()) {
                this.outDir = f;
                this.txtOutputDirectory.setText(f.getPath());
                this.checkIfRunnable();
            } else {
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("com/jansensystems/pdfspicer/Bundle").getString("MainWindow.error.directory.invalid"), ResourceBundle.getBundle("com/jansensystems/pdfspicer/Bundle").getString("ERROR"), 0);
            }
        }
    }

    private void btnRunActionPerformed(ActionEvent evt) {
        this.glassPane.setVisible(true);
        Thread watermarker = new Thread(new Runnable(){

            public void run() {
                boolean i = false;
                try {
                    for (PDFFile f : ((PDFFileModel)MainWindow.this.tblInputFiles.getModel()).getPDFFiles()) {
                        try {
                            File input = f.getFile();
                            File out = new File(MainWindow.this.outDir, input.getName());
                            if ((!out.exists() || !out.canWrite()) && !out.createNewFile()) continue;
                            MainWindow.this.glassPane.resetProgress();
                            MainWindow.this.glassPane.setTitle(ResourceBundle.getBundle("com/jansensystems/pdfspicer/Bundle").getString("MainWindow.glassPane.title.Processing_file") + input.getName());
                            Watermarker wm = new Watermarker(input, out);
                            wm.setProgressListener(MainWindow.this.progressListener);
                            if (MainWindow.this.ckWatermark.isSelected()) {
                                wm.setWatermarkText(MainWindow.this.txtWatermark.getText());
                            }
                            if (MainWindow.this.ckTitle.isSelected()) {
                                if (MainWindow.this.ckFileNameAsText.isSelected()) {
                                    wm.setTitleText(input.getName().replaceAll("\\.pdf", ""));
                                } else {
                                    wm.setTitleText(MainWindow.this.txtHeadlineText.getText());
                                }
                                wm.setMaxTitleFontSize((Integer)MainWindow.this.spMaxFontSize.getValue());
                                wm.setTopSpacing((Integer)MainWindow.this.spTopSpacing.getValue());
                            }
                            if (MainWindow.this.ckSplit.isSelected()) {
                                if (MainWindow.this.radioNumberOfParts.isSelected()) {
                                    wm.setSplitPages((Integer)MainWindow.this.spSplitParts.getValue());
                                } else if (MainWindow.this.radioPagesPerPart.isSelected()) {
                                    wm.setSplitPagesPerPart((Integer)MainWindow.this.spPagesPerPage.getValue());
                                }
                            }
                            wm.watermark();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                MainWindow.this.glassPane.setVisible(false);
                MainWindow.this.glassPane.resetProgress();
            }
        });
        watermarker.start();
    }

    private void btnAddFilesActionPerformed(ActionEvent evt) {
        this.fileChooser = this.lastDir == null ? new JFileChooser() : new JFileChooser(this.lastDir);
        PDFFilter pdffilter = new PDFFilter();
        this.fileChooser.addChoosableFileFilter(pdffilter);
        this.fileChooser.setFileFilter(pdffilter);
        this.fileChooser.setDialogTitle(ResourceBundle.getBundle("com/jansensystems/pdfspicer/Bundle").getString("MainWindow.filechooser.title.addfiles"));
        this.fileChooser.setApproveButtonText(ResourceBundle.getBundle("com/jansensystems/pdfspicer/Bundle").getString("MainWindow.filechooser.button.addfiles"));
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.setMultiSelectionEnabled(true);
        this.fileChooser.setAcceptAllFileFilterUsed(false);
        if (this.fileChooser.showOpenDialog(this) == 0) {
            File[] files;
            this.lastDir = this.fileChooser.getCurrentDirectory();
            for (File f : files = this.fileChooser.getSelectedFiles()) {
                if (f.exists() && !f.isDirectory() && f.canRead()) {
                    try {
                        ((PDFFileModel)this.tblInputFiles.getModel()).addPDF(f);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("com/jansensystems/pdfspicer/Bundle").getString("MainWindow.error.file.invalid"), ResourceBundle.getBundle("com/jansensystems/pdfspicer/Bundle").getString("ERROR"), 0);
                    }
                    continue;
                }
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("com/jansensystems/pdfspicer/Bundle").getString("MainWindow.error.file.invalid"), ResourceBundle.getBundle("com/jansensystems/pdfspicer/Bundle").getString("ERROR"), 0);
            }
            this.checkIfRunnable();
        }
    }

    private void radioNumberOfPartsActionPerformed(ActionEvent evt) {
        this.spSplitParts.setEnabled(this.radioNumberOfParts.isSelected());
        this.spPagesPerPage.setEnabled(this.radioPagesPerPart.isSelected());
    }

    private void radioPagesPerPartActionPerformed(ActionEvent evt) {
        this.spPagesPerPage.setEnabled(this.radioPagesPerPart.isSelected());
        this.spSplitParts.setEnabled(this.radioNumberOfParts.isSelected());
    }
}

