/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.xml.simpleparser;

import com.lowagie.text.xml.simpleparser.EntitiesToUnicode;
import com.lowagie.text.xml.simpleparser.IanaEncodings;
import com.lowagie.text.xml.simpleparser.SimpleXMLDocHandler;
import com.lowagie.text.xml.simpleparser.SimpleXMLDocHandlerComment;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Stack;

public class SimpleXMLParser {
    private static final int TEXT = 1;
    private static final int ENTITY = 2;
    private static final int OPEN_TAG = 3;
    private static final int CLOSE_TAG = 4;
    private static final int START_TAG = 5;
    private static final int ATTRIBUTE_LVALUE = 6;
    private static final int ATTRIBUTE_EQUAL = 9;
    private static final int ATTRIBUTE_RVALUE = 10;
    private static final int QUOTE = 7;
    private static final int IN_TAG = 8;
    private static final int SINGLE_TAG = 12;
    private static final int COMMENT = 13;
    private static final int DONE = 11;
    private static final int DOCTYPE = 14;
    private static final int PRE = 15;
    private static final int CDATA = 16;

    private static int popMode(Stack st) {
        if (!st.empty()) {
            return (Integer)st.pop();
        }
        return 15;
    }

    private SimpleXMLParser() {
    }

    public static void parse(SimpleXMLDocHandler doc, InputStream in) throws IOException {
        byte[] b4 = new byte[4];
        int count = in.read(b4);
        if (count != 4) {
            throw new IOException("Insufficient length.");
        }
        String encoding = SimpleXMLParser.getEncodingName(b4);
        String decl = null;
        if (encoding.equals("UTF-8")) {
            int c;
            StringBuffer sb = new StringBuffer();
            while ((c = in.read()) != -1) {
                if (c == 62) break;
                sb.append((char)c);
            }
            decl = sb.toString();
        } else if (encoding.equals("CP037")) {
            int c;
            ByteArrayOutputStream bi = new ByteArrayOutputStream();
            while ((c = in.read()) != -1) {
                if (c == 110) break;
                bi.write(c);
            }
            decl = new String(bi.toByteArray(), "CP037");
        }
        if (decl != null && (decl = SimpleXMLParser.getDeclaredEncoding(decl)) != null) {
            encoding = decl;
        }
        SimpleXMLParser.parse(doc, new InputStreamReader(in, IanaEncodings.getJavaEncoding(encoding)));
    }

    private static String getDeclaredEncoding(String decl) {
        int idx2;
        if (decl == null) {
            return null;
        }
        int idx = decl.indexOf("encoding");
        if (idx < 0) {
            return null;
        }
        int idx1 = decl.indexOf(34, idx);
        if (idx1 == (idx2 = decl.indexOf(39, idx))) {
            return null;
        }
        if (idx1 < 0 && idx2 > 0 || idx2 > 0 && idx2 < idx1) {
            int idx3 = decl.indexOf(39, idx2 + 1);
            if (idx3 < 0) {
                return null;
            }
            return decl.substring(idx2 + 1, idx3);
        }
        if (idx2 < 0 && idx1 > 0 || idx1 > 0 && idx1 < idx2) {
            int idx3 = decl.indexOf(34, idx1 + 1);
            if (idx3 < 0) {
                return null;
            }
            return decl.substring(idx1 + 1, idx3);
        }
        return null;
    }

    public static void parse(SimpleXMLDocHandler doc, Reader r) throws IOException {
        SimpleXMLParser.parse(doc, null, r, false);
    }

    public static void parse(SimpleXMLDocHandler doc, SimpleXMLDocHandlerComment comment, Reader r, boolean html) throws IOException {
        BufferedReader reader = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
        Stack<Integer> st = new Stack<Integer>();
        int depth = 0;
        int mode = 15;
        int c = 0;
        int quotec = 34;
        depth = 0;
        StringBuffer sb = new StringBuffer();
        StringBuffer etag = new StringBuffer();
        String tagName = null;
        String lvalue = null;
        String rvalue = null;
        HashMap<String, String> attrs = null;
        st = new Stack();
        doc.startDocument();
        int line = 1;
        int col = 0;
        boolean eol = false;
        if (html) {
            mode = 1;
        }
        int pushBack = -1;
        while (true) {
            if (pushBack != -1) {
                c = pushBack;
                pushBack = -1;
            } else {
                c = reader.read();
            }
            if (c == -1) break;
            if (c == 10 && eol) {
                eol = false;
                continue;
            }
            if (eol) {
                eol = false;
            } else if (c == 10) {
                ++line;
                col = 0;
            } else if (c == 13) {
                eol = true;
                c = 10;
                ++line;
                col = 0;
            } else {
                ++col;
            }
            if (mode == 11) {
                doc.endDocument();
                return;
            }
            if (mode == 1) {
                if (c == 60) {
                    st.push(new Integer(mode));
                    mode = 5;
                    if (sb.length() <= 0) continue;
                    doc.text(sb.toString());
                    sb.setLength(0);
                    continue;
                }
                if (c == 38) {
                    st.push(new Integer(mode));
                    mode = 2;
                    etag.setLength(0);
                    continue;
                }
                sb.append((char)c);
                continue;
            }
            if (mode == 4) {
                if (c == 62) {
                    mode = SimpleXMLParser.popMode(st);
                    tagName = sb.toString();
                    if (html) {
                        tagName = tagName.toLowerCase();
                    }
                    sb.setLength(0);
                    if (!html && --depth == 0) {
                        mode = 11;
                    }
                    doc.endElement(tagName);
                    continue;
                }
                if (Character.isWhitespace((char)c)) continue;
                sb.append((char)c);
                continue;
            }
            if (mode == 16) {
                if (c == 62 && sb.toString().endsWith("]]")) {
                    sb.setLength(sb.length() - 2);
                    doc.text(sb.toString());
                    sb.setLength(0);
                    mode = SimpleXMLParser.popMode(st);
                    continue;
                }
                sb.append((char)c);
                continue;
            }
            if (mode == 13) {
                if (c == 62 && sb.toString().endsWith("--")) {
                    if (comment != null) {
                        sb.setLength(sb.length() - 2);
                        comment.comment(sb.toString());
                    }
                    sb.setLength(0);
                    mode = SimpleXMLParser.popMode(st);
                    continue;
                }
                sb.append((char)c);
                continue;
            }
            if (mode == 15) {
                if (c != 60) continue;
                mode = 1;
                st.push(new Integer(mode));
                mode = 5;
                continue;
            }
            if (mode == 14) {
                if (c != 62 || (mode = SimpleXMLParser.popMode(st)) != 1) continue;
                mode = 15;
                continue;
            }
            if (mode == 5) {
                mode = SimpleXMLParser.popMode(st);
                if (c == 47) {
                    st.push(new Integer(mode));
                    mode = 4;
                    continue;
                }
                if (c == 63) {
                    mode = 14;
                    continue;
                }
                st.push(new Integer(mode));
                mode = 3;
                tagName = null;
                attrs = new HashMap<String, String>();
                sb.append((char)c);
                continue;
            }
            if (mode == 2) {
                if (c == 59) {
                    mode = SimpleXMLParser.popMode(st);
                    String cent = etag.toString();
                    etag.setLength(0);
                    if (cent.startsWith("#x")) {
                        try {
                            char ci = (char)Integer.parseInt(cent.substring(2), 16);
                            sb.append(ci);
                        }
                        catch (Exception es) {
                            sb.append('&').append(cent).append(';');
                        }
                        continue;
                    }
                    if (cent.startsWith("#")) {
                        try {
                            char ci = (char)Integer.parseInt(cent.substring(1));
                            sb.append(ci);
                        }
                        catch (Exception es) {
                            sb.append('&').append(cent).append(';');
                        }
                        continue;
                    }
                    char ce = EntitiesToUnicode.decodeEntity(cent);
                    if (ce == '\u0000') {
                        sb.append('&').append(cent).append(';');
                        continue;
                    }
                    sb.append(ce);
                    continue;
                }
                if (!((c == 35 || c >= 48 && c <= 57 || c >= 97 && c <= 122 || c >= 65 && c <= 90) && etag.length() < 7)) {
                    mode = SimpleXMLParser.popMode(st);
                    pushBack = c;
                    sb.append('&').append(etag.toString());
                    etag.setLength(0);
                    continue;
                }
                etag.append((char)c);
                continue;
            }
            if (mode == 12) {
                if (tagName == null) {
                    tagName = sb.toString();
                }
                if (html) {
                    tagName = tagName.toLowerCase();
                }
                if (c != 62) {
                    SimpleXMLParser.exc("Expected > for tag: <" + tagName + "/>", line, col);
                }
                doc.startElement(tagName, attrs);
                doc.endElement(tagName);
                if (!html && depth == 0) {
                    doc.endDocument();
                    return;
                }
                sb.setLength(0);
                attrs = new HashMap();
                tagName = null;
                mode = SimpleXMLParser.popMode(st);
                continue;
            }
            if (mode == 3) {
                if (c == 62) {
                    if (tagName == null) {
                        tagName = sb.toString();
                    }
                    if (html) {
                        tagName = tagName.toLowerCase();
                    }
                    sb.setLength(0);
                    ++depth;
                    doc.startElement(tagName, attrs);
                    tagName = null;
                    attrs = new HashMap();
                    mode = SimpleXMLParser.popMode(st);
                    continue;
                }
                if (c == 47) {
                    mode = 12;
                    continue;
                }
                if (c == 45 && sb.toString().equals("!-")) {
                    mode = 13;
                    sb.setLength(0);
                    continue;
                }
                if (c == 91 && sb.toString().equals("![CDATA")) {
                    mode = 16;
                    sb.setLength(0);
                    continue;
                }
                if (c == 69 && sb.toString().equals("!DOCTYP")) {
                    sb.setLength(0);
                    mode = 14;
                    continue;
                }
                if (Character.isWhitespace((char)c)) {
                    tagName = sb.toString();
                    if (html) {
                        tagName = tagName.toLowerCase();
                    }
                    sb.setLength(0);
                    mode = 8;
                    continue;
                }
                sb.append((char)c);
                continue;
            }
            if (mode == 7) {
                if (html && quotec == 32 && c == 62) {
                    rvalue = sb.toString();
                    sb.setLength(0);
                    attrs.put(lvalue, rvalue);
                    mode = SimpleXMLParser.popMode(st);
                    doc.startElement(tagName, attrs);
                    ++depth;
                    tagName = null;
                    attrs = new HashMap();
                    continue;
                }
                if (html && quotec == 32 && Character.isWhitespace((char)c)) {
                    rvalue = sb.toString();
                    sb.setLength(0);
                    attrs.put(lvalue, rvalue);
                    mode = 8;
                    continue;
                }
                if (html && quotec == 32) {
                    sb.append((char)c);
                    continue;
                }
                if (c == quotec) {
                    rvalue = sb.toString();
                    sb.setLength(0);
                    attrs.put(lvalue, rvalue);
                    mode = 8;
                    continue;
                }
                if (" \r\n\t".indexOf(c) >= 0) {
                    sb.append(' ');
                    continue;
                }
                if (c == 38) {
                    st.push(new Integer(mode));
                    mode = 2;
                    etag.setLength(0);
                    continue;
                }
                sb.append((char)c);
                continue;
            }
            if (mode == 10) {
                if (c == 34 || c == 39) {
                    quotec = c;
                    mode = 7;
                    continue;
                }
                if (Character.isWhitespace((char)c)) continue;
                if (html && c == 62) {
                    attrs.put(lvalue, sb.toString());
                    sb.setLength(0);
                    mode = SimpleXMLParser.popMode(st);
                    doc.startElement(tagName, attrs);
                    ++depth;
                    tagName = null;
                    attrs = new HashMap();
                    continue;
                }
                if (html) {
                    sb.append((char)c);
                    quotec = 32;
                    mode = 7;
                    continue;
                }
                SimpleXMLParser.exc("Error in attribute processing", line, col);
                continue;
            }
            if (mode == 6) {
                if (Character.isWhitespace((char)c)) {
                    lvalue = sb.toString();
                    if (html) {
                        lvalue = lvalue.toLowerCase();
                    }
                    sb.setLength(0);
                    mode = 9;
                    continue;
                }
                if (c == 61) {
                    lvalue = sb.toString();
                    if (html) {
                        lvalue = lvalue.toLowerCase();
                    }
                    sb.setLength(0);
                    mode = 10;
                    continue;
                }
                if (html && c == 62) {
                    sb.setLength(0);
                    mode = SimpleXMLParser.popMode(st);
                    doc.startElement(tagName, attrs);
                    ++depth;
                    tagName = null;
                    attrs = new HashMap();
                    continue;
                }
                sb.append((char)c);
                continue;
            }
            if (mode == 9) {
                if (c == 61) {
                    mode = 10;
                    continue;
                }
                if (Character.isWhitespace((char)c)) continue;
                if (html && c == 62) {
                    sb.setLength(0);
                    mode = SimpleXMLParser.popMode(st);
                    doc.startElement(tagName, attrs);
                    ++depth;
                    tagName = null;
                    attrs = new HashMap();
                    continue;
                }
                if (html && c == 47) {
                    sb.setLength(0);
                    mode = 12;
                    continue;
                }
                if (html) {
                    sb.setLength(0);
                    sb.append((char)c);
                    mode = 6;
                    continue;
                }
                SimpleXMLParser.exc("Error in attribute processing.", line, col);
                continue;
            }
            if (mode != 8) continue;
            if (c == 62) {
                mode = SimpleXMLParser.popMode(st);
                doc.startElement(tagName, attrs);
                ++depth;
                tagName = null;
                attrs = new HashMap();
                continue;
            }
            if (c == 47) {
                mode = 12;
                continue;
            }
            if (Character.isWhitespace((char)c)) continue;
            mode = 6;
            sb.append((char)c);
        }
        if (html || mode == 11) {
            if (html && mode == 1) {
                doc.text(sb.toString());
            }
            doc.endDocument();
        } else {
            SimpleXMLParser.exc("missing end tag", line, col);
        }
    }

    private static void exc(String s, int line, int col) throws IOException {
        throw new IOException(String.valueOf(s) + " near line " + line + ", column " + col);
    }

    public static String escapeXML(String s, boolean onlyASCII) {
        char[] cc = s.toCharArray();
        int len = cc.length;
        StringBuffer sb = new StringBuffer();
        int k = 0;
        while (k < len) {
            char c = cc[k];
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case '\'': {
                    sb.append("&apos;");
                    break;
                }
                default: {
                    if (onlyASCII && c > '\u007f') {
                        sb.append("&#").append((int)c).append(';');
                        break;
                    }
                    sb.append(c);
                }
            }
            ++k;
        }
        return sb.toString();
    }

    private static String getEncodingName(byte[] b4) {
        int b0 = b4[0] & 0xFF;
        int b1 = b4[1] & 0xFF;
        if (b0 == 254 && b1 == 255) {
            return "UTF-16BE";
        }
        if (b0 == 255 && b1 == 254) {
            return "UTF-16LE";
        }
        int b2 = b4[2] & 0xFF;
        if (b0 == 239 && b1 == 187 && b2 == 191) {
            return "UTF-8";
        }
        int b3 = b4[3] & 0xFF;
        if (b0 == 0 && b1 == 0 && b2 == 0 && b3 == 60) {
            return "ISO-10646-UCS-4";
        }
        if (b0 == 60 && b1 == 0 && b2 == 0 && b3 == 0) {
            return "ISO-10646-UCS-4";
        }
        if (b0 == 0 && b1 == 0 && b2 == 60 && b3 == 0) {
            return "ISO-10646-UCS-4";
        }
        if (b0 == 0 && b1 == 60 && b2 == 0 && b3 == 0) {
            return "ISO-10646-UCS-4";
        }
        if (b0 == 0 && b1 == 60 && b2 == 0 && b3 == 63) {
            return "UTF-16BE";
        }
        if (b0 == 60 && b1 == 0 && b2 == 63 && b3 == 0) {
            return "UTF-16LE";
        }
        if (b0 == 76 && b1 == 111 && b2 == 167 && b3 == 148) {
            return "CP037";
        }
        return "UTF-8";
    }
}

