/*
 * Decompiled with CFR 0.152.
 */
package com.jansensystems.jswidgets.renderer;

import java.awt.Component;
import java.io.File;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class TableFileRenderer
extends DefaultTableCellRenderer {
    private static final long GB = 0x40000000L;
    private static final long MB = 0x100000L;
    private static final long KB = 1024L;
    private int namecol = 0;
    private int sizecol = 0;

    public TableFileRenderer(int namecol, int sizecol) {
        this.namecol = namecol;
        this.sizecol = sizecol;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof File) {
            if (column == this.sizecol) {
                ((DefaultTableCellRenderer)cell).setHorizontalAlignment(11);
                long length = ((File)value).length();
                if (length > 0x40000000L) {
                    ((DefaultTableCellRenderer)cell).setText(String.format("%.2f GB", Float.valueOf((float)length / 1.0737418E9f)));
                } else if (length > 0x100000L) {
                    ((DefaultTableCellRenderer)cell).setText(String.format("%.2f MB", Float.valueOf((float)length / 1048576.0f)));
                } else if (length > 1024L) {
                    ((DefaultTableCellRenderer)cell).setText(String.format("%.2f KB", Float.valueOf((float)length / 1024.0f)));
                } else {
                    ((DefaultTableCellRenderer)cell).setText(String.format("%d Byte", length));
                }
            } else if (column == this.namecol) {
                ((DefaultTableCellRenderer)cell).setHorizontalAlignment(10);
                ((DefaultTableCellRenderer)cell).setText(((File)value).getName());
            }
        }
        return cell;
    }
}

