/*
 * Decompiled with CFR 0.152.
 */
package com.jansensystems.jswidgets.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class ComponentTitledBorder
implements Border,
MouseListener,
SwingConstants {
    private int offset = 10;
    private int margin = 4;
    private Component comp;
    private JComponent container;
    private Rectangle rect;
    private Border border;
    private Color bgColor = null;

    public ComponentTitledBorder(Component comp, JComponent container, Border border) {
        this.comp = comp;
        this.container = container;
        this.border = border;
        container.addMouseListener(this);
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.bgColor == null) {
            this.bgColor = ((Graphics2D)g).getBackground();
        } else {
            ((Graphics2D)g).setBackground(this.bgColor);
        }
        Insets borderInsets = this.border.getBorderInsets(c);
        Insets insets = this.getBorderInsets(c);
        int temp = (insets.top - borderInsets.top) / 2;
        this.border.paintBorder(c, g, x, y + temp, width, height - temp);
        Dimension size = this.comp.getPreferredSize();
        this.rect = new Rectangle(this.offset, 0, size.width, size.height);
        g.clearRect(this.offset - this.margin, 0, size.width + 2 * this.margin, size.height);
        SwingUtilities.paintComponent(g, this.comp, (Container)c, this.rect);
    }

    public Insets getBorderInsets(Component c) {
        Dimension size = this.comp.getPreferredSize();
        Insets insets = this.border.getBorderInsets(c);
        insets.top = Math.max(insets.top, size.height);
        return insets;
    }

    private void dispatchEvent(MouseEvent me) {
        if (this.rect != null && this.rect.contains(me.getX(), me.getY())) {
            Point pt = me.getPoint();
            pt.translate(-this.offset, 0);
            this.comp.setSize(this.rect.width, this.rect.height);
            this.comp.dispatchEvent(new MouseEvent(this.comp, me.getID(), me.getWhen(), me.getModifiers(), pt.x, pt.y, me.getClickCount(), me.isPopupTrigger(), me.getButton()));
            if (!this.comp.isValid()) {
                this.container.repaint();
            }
        }
    }

    public void mouseClicked(MouseEvent me) {
        this.dispatchEvent(me);
    }

    public void mouseEntered(MouseEvent me) {
        this.dispatchEvent(me);
    }

    public void mouseExited(MouseEvent me) {
        this.dispatchEvent(me);
    }

    public void mousePressed(MouseEvent me) {
        this.dispatchEvent(me);
    }

    public void mouseReleased(MouseEvent me) {
        this.dispatchEvent(me);
    }
}

