/*
 * Decompiled with CFR 0.152.
 */
package com.jansensystems.jswidgets;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;

public class ProgressGlassPane
extends JComponent {
    private int barWidth = 200;
    private int barHeight = 10;
    private float opacity = 0.65f;
    private Color textColor = new Color(0x333333);
    private float[] progessGradientFractions = new float[]{0.0f, 0.499f, 0.5f, 1.0f};
    private Color[] progressGradientColors = new Color[]{Color.GRAY, Color.DARK_GRAY, Color.BLACK, Color.GRAY};
    private Color backgroundGradientColor2 = Color.WHITE;
    private Color backgroundGradientColor1 = Color.GRAY;
    private String message = "Downloading file...";
    private int progress = 0;

    public ProgressGlassPane(String title) {
        this.message = title;
        this.setBackground(Color.WHITE);
        this.setFont(new Font("Default", 1, 16));
        this.addMouseListener(new MouseAdapter(){});
        this.addMouseMotionListener(new MouseMotionAdapter(){});
        this.addKeyListener(new KeyAdapter(){});
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                ProgressGlassPane.this.requestFocusInWindow();
            }
        });
        this.setFocusTraversalKeysEnabled(false);
    }

    public void setTitle(String t) {
        this.message = t;
        FontMetrics metrics = this.getGraphics().getFontMetrics(this.getFont());
        int offset = metrics.getDescent() + metrics.getAscent();
        int x = (this.getWidth() - this.barWidth) / 2;
        int y = (this.getHeight() - this.barHeight - metrics.getDescent()) / 2;
        int width = metrics.stringWidth(this.message);
        int height = metrics.getHeight();
        this.repaint(x - 5, y - (height + offset), width + 10, height + 2 * offset);
    }

    public int getProgress() {
        return this.progress;
    }

    public void resetProgress() {
        FontMetrics metrics = this.getGraphics().getFontMetrics(this.getFont());
        int w = 0;
        int x = w + (this.getWidth() - this.barWidth) / 2;
        int y = (this.getHeight() - this.barHeight) / 2;
        w = this.barWidth - w;
        int h = this.barHeight;
        this.progress = 0;
        this.repaint(x, y += metrics.getDescent() / 2, w, h);
    }

    public void setProgress(int progress) {
        int oldProgress = this.progress;
        this.progress = progress;
        FontMetrics metrics = this.getGraphics().getFontMetrics(this.getFont());
        int w = (int)((float)this.barWidth * ((float)oldProgress / 100.0f));
        int x = w + (this.getWidth() - this.barWidth) / 2;
        int y = (this.getHeight() - this.barHeight) / 2;
        w = (int)((float)this.barWidth * ((float)progress / 100.0f)) - w;
        int h = this.barHeight;
        this.repaint(x, y += metrics.getDescent() / 2, w, h);
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle clip = g.getClipBounds();
        AlphaComposite alpha = AlphaComposite.SrcOver.derive(this.opacity);
        Composite composite = g2.getComposite();
        g2.setComposite(alpha);
        g2.setColor(this.getBackground());
        g2.fillRect(clip.x, clip.y, clip.width, clip.height);
        FontMetrics metrics = g.getFontMetrics();
        int x = (this.getWidth() - this.barWidth) / 2;
        int y = (this.getHeight() - this.barHeight - metrics.getDescent()) / 2;
        g2.setColor(this.textColor);
        g2.drawString(this.message, x, y);
        int w = (int)((float)this.barWidth * ((float)this.progress / 100.0f));
        int h = this.barHeight;
        Paint paint = g2.getPaint();
        Paint gradient = new GradientPaint(x, y += metrics.getDescent(), this.backgroundGradientColor1, x, y + h, this.backgroundGradientColor2);
        g2.setPaint(gradient);
        g2.fillRect(x, y, this.barWidth, this.barHeight);
        gradient = new LinearGradientPaint(x, y, x, y + h, this.progessGradientFractions, this.progressGradientColors);
        g2.setPaint(gradient);
        g2.fillRect(x, y, w, h);
        g2.setPaint(paint);
        g2.drawRect(x, y, this.barWidth, this.barHeight);
        g2.setComposite(composite);
    }

    public int getBarWidth() {
        return this.barWidth;
    }

    public void setBarWidth(int barWidth) {
        this.barWidth = barWidth;
    }

    public int getBarHeight() {
        return this.barHeight;
    }

    public void setBarHeight(int barHeight) {
        this.barHeight = barHeight;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(float opacity) {
        this.opacity = opacity;
    }

    public Color getBackgroundGradientColor2() {
        return this.backgroundGradientColor2;
    }

    public void setBackgroundGradientColor2(Color backgroundGradientColor2) {
        this.backgroundGradientColor2 = backgroundGradientColor2;
    }

    public Color getBackgroundGradientColor1() {
        return this.backgroundGradientColor1;
    }

    public void setBackgroundGradientColor1(Color backgroundGradientColor1) {
        this.backgroundGradientColor1 = backgroundGradientColor1;
    }

    public float[] getProgessGradientFractions() {
        return this.progessGradientFractions;
    }

    public void setProgessGradientFractions(float[] progessGradientFractions) {
        this.progessGradientFractions = progessGradientFractions;
    }

    public Color[] getProgressGradientColors() {
        return this.progressGradientColors;
    }

    public void setProgressGradientColors(Color[] progressGradientColors) {
        this.progressGradientColors = progressGradientColors;
    }
}

