/*
 * Decompiled with CFR 0.152.
 */
package com.jansensystems.jswidgets;

import com.jansensystems.jswidgets.FileDropTableListener;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.swing.JTable;
import javax.swing.JViewport;

public class JFileDropTable
extends JTable
implements DropTargetListener {
    public static final int DROP_TO_TABLE = 0;
    public static final int DROP_TO_ROW = 1;
    private DropTarget dropTarget = null;
    private FileDropTableListener fileDropListener = null;
    private int dropSetting = 0;

    public JFileDropTable() {
        this(0);
    }

    public JFileDropTable(int dropsetting) {
        System.out.println("Constructor");
        this.dropSetting = dropsetting;
        this.dropTarget = new DropTarget(this, this);
    }

    public boolean getScrollableTracksViewportHeight() {
        Container viewport = this.getParent();
        if (!(viewport instanceof JViewport)) {
            return false;
        }
        return this.getPreferredSize().height < viewport.getHeight();
    }

    public void dragEnter(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
        if (this.dropSetting == 1) {
            int i = this.rowAtPoint(dtde.getLocation());
            if (i == -1) {
                dtde.rejectDrag();
            } else {
                dtde.acceptDrag(dtde.getDropAction());
                this.setRowSelectionInterval(i, i);
            }
        } else {
            dtde.acceptDrag(dtde.getDropAction());
        }
    }

    public void drop(DropTargetDropEvent event) {
        int row = this.rowAtPoint(event.getLocation());
        try {
            event.acceptDrop(1);
            Transferable transferable = event.getTransferable();
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String ss = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                String[] files = ss.split("\n");
                for (int i = 0; i < files.length; ++i) {
                    try {
                        File f;
                        if (files[i].length() <= 0 || !this.accept(f = new File(new URI(files[i].trim())))) continue;
                        this.fileDropListener.fileDropped(f, row);
                        continue;
                    }
                    catch (URISyntaxException e) {
                        System.out.println(e);
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println(e);
                    }
                }
            } else if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List l = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                for (int i = 0; i < l.size(); ++i) {
                    if (!this.accept((File)l.get(i))) continue;
                    this.fileDropListener.fileDropped((File)l.get(i), row);
                }
                event.getDropTargetContext().dropComplete(true);
            } else {
                event.rejectDrop();
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
            System.err.println("Exception" + exception.getMessage());
            event.rejectDrop();
        }
        catch (UnsupportedFlavorException ufException) {
            ufException.printStackTrace();
            System.err.println("Exception" + ufException.getMessage());
            event.rejectDrop();
        }
        this.fileDropListener.done();
    }

    private boolean accept(File f) {
        if (this.fileDropListener == null || !f.exists()) {
            return false;
        }
        return this.fileDropListener.acceptFile(f);
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public FileDropTableListener getFileDropListener() {
        return this.fileDropListener;
    }

    public void setFileDropListener(FileDropTableListener fileDropListener) {
        this.fileDropListener = fileDropListener;
    }
}

